/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "GstreamerCommon.h"
#include "GstreamerVideoOut.h"


LOG_DECLARE_CONTEXT(dipo_gst);

using namespace adit::carplay;

extern "C" void carplay_LibraryEntryPoint()
{
    // register gstreamer at logging
    LOG_REGISTER_CONTEXT(dipo_gst, "CGST", "CarPlay Gstreamer video");
    LOGD_DEBUG((dipo_gst, "carplay-gstreamer git tag: %s", COMP_GIT_VERSION));

    GError* error = nullptr;
    gboolean ret = gst_init_check(NULL, NULL, &error);
    if (ret == TRUE)
    {
        // only register if Gstreamer could initialize
        carplay_FactoryRegister<IVideoOutAdapter, GstreamerVideoOut>("GstreamerVideoOut");

    }
    else
    {
        if (error != nullptr)
        {
            LOG_ERROR((dipo_gst, "gst_init_check failed: %s", error->message));
            g_error_free(error);
        }
        else
        {
            LOG_ERROR((dipo_gst, "gst_init_check failed (unknown error)"));
        }

        LOG_FATAL((dipo_gst, "unable to register Gstreamer adapters"));
    }
}

extern "C" void carplay_LibraryExitPoint()
{
    LOG_UNREGISTER_CONTEXT(dipo_gst);
}
